import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Schema as MongooseSchema } from 'mongoose';

import { REACTION_ACTION, REACTION_TYPE } from 'src/constants';

@Schema({
  collection: 'reactions'
})
export class Reaction {
  @Prop({
    index: true,
    default: REACTION_ACTION.LIKE
  })
  action: string;

  @Prop({
    index: true,
    default: REACTION_TYPE.VIDEO
  })
  objectType: string;

  @Prop({
    type: MongooseSchema.Types.ObjectId,
    index: true
  })
  objectId: ObjectId;

  @Prop({
    index: true,
    type: ObjectId
  })
  createdBy: ObjectId;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type ReactionDocument = HydratedDocument<Reaction>;

export const ReactionSchema = SchemaFactory.createForClass(Reaction);
