import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Schema as MongooseSchema } from 'mongoose';

import { STATUS } from 'src/constants';

export type ProfileDocument = HydratedDocument<Profile>;

@Schema({
  collection: 'profiles'
})
export class Profile {
  @Prop()
  name: string;

  @Prop()
  firstName: string;

  @Prop()
  lastName: string;

  @Prop({
    unique: true,
    trim: true
  })
  username: string;

  @Prop({
    unique: true,
    trim: true,
    lowercase: true,
    // uniq if not null
    sparse: true
  })
  email: string;

  @Prop()
  gender: string;

  @Prop({
    default: STATUS.INACTIVE
  })
  status: string;

  @Prop()
  avatar: string; // full URL to avatar url

  @Prop({
    type: MongooseSchema.Types.ObjectId
  })
  avatarId: ObjectId;

  @Prop({
    default: 0
  })
  balance: number;

  @Prop()
  country: string;

  @Prop()
  address: string;

  @Prop()
  bio: string;

  @Prop({
    default: false
  })
  verifiedEmail: boolean;

  @Prop({
    default: false
  })
  verifiedAccount: boolean;

  @Prop({
    default: false
  })
  verifiedDocument: boolean;

  @Prop({
    default: ['user']
  })
  roles: string[];

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;

  @Prop({
    type: Date
  })
  dateOfBirth: Date;
}

export const ProfileSchema = SchemaFactory.createForClass(Profile);
