import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Schema as MongooseSchema } from 'mongoose';

@Schema({
  collection: 'profile_verifications'
})
export class ProfileVerification {
  @Prop({
    index: true,
    type: MongooseSchema.Types.ObjectId
  })
  profileId: ObjectId;

  @Prop({
    index: true
  })
  type: string; // email, phone, etc...

  @Prop({
    index: true
  })
  value: string;

  @Prop({
    index: true
  })
  token: string;

  @Prop({
    index: true
  })
  verified: boolean;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type ProfileVerificationDocument = HydratedDocument<ProfileVerification>;

export const ProfileVerificationSchema = SchemaFactory.createForClass(ProfileVerification);
