import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Schema as MongooseSchema } from 'mongoose';

import { Category } from 'src/schemas';

@Schema({
  collection: 'posts'
})
export class Post {
  @Prop({
    trim: true
  })
  title: string;

  @Prop()
  content: string;

  @Prop({
    trim: true
  })
  slug: string; // alias name for SEO

  @Prop()
  seoTitle: string;

  @Prop()
  seoDesc: string;

  @Prop()
  seoKeywords: string;

  @Prop()
  status: string;

  @Prop({
    type: [{
      type: MongooseSchema.Types.ObjectId
    }],
    index: true
  })
  categoryIds: ObjectId[];

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type PostDocument = HydratedDocument<Post>;

export const PostSchema = SchemaFactory.createForClass(Post);

PostSchema.index({ slug: 1 }, { unique: true, sparse: true });
PostSchema.index({ title: 1 });
PostSchema.index({ title: 'text' });
PostSchema.virtual('categories', {
  ref: Category.name,
  localField: 'categoryIds',
  foreignField: '_id'
});
