import {
  Prop, Schema, SchemaFactory, raw
} from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Types } from 'mongoose';

@Schema({
  collection: 'performers'
})
export class Performer {
  @Prop()
  name: string;

  @Prop({
    trim: true
  })
  username: string;

  @Prop()
  gender: string;

  @Prop()
  bio: string;

  @Prop({
    default: 'active',
    index: true
  })
  status: string;

  @Prop({
    type: Types.ObjectId
  })
  avatarId: ObjectId;

  @Prop({
    type: Types.ObjectId
  })
  coverId: ObjectId;

  @Prop({
    type: ObjectId
  })
  createdBy: ObjectId;

  @Prop(raw({
    likes: { type: Number, default: 0 },
    views: { type: Number, default: 0 },
    videos: { type: Number, default: 0 },
    totalVideoViews: { type: Number, default: 0 }
  }))
  stats: {
    likes: number,
    views: number,
    videos: number,
    totalVideoViews: number;
  };

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;

  @Prop()
  seoTitle: string;

  @Prop()
  seoKeywords: string;

  @Prop()
  seoDesc: string;
}

export type PerformerDocument = HydratedDocument<Performer>;

export const PerformerSchema = SchemaFactory.createForClass(Performer);
PerformerSchema.index({ username: 1 }, { unique: true, sparse: true });
PerformerSchema.index({ name: 1 });
PerformerSchema.index({ name: 'text' });
