import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Schema as MongooseSchema } from 'mongoose';

@Schema({
  collection: 'forgot_password'
})
export class ForgotPassword {
  @Prop({
    index: true,
    type: MongooseSchema.Types.ObjectId
  })
  profileId: ObjectId;

  @Prop({
    index: true
  })
  token: string;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;
}

export type ForgotPasswordDoument = HydratedDocument<ForgotPassword>;

export const ForgotPasswordSchema = SchemaFactory.createForClass(ForgotPassword);
