import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { HydratedDocument } from 'mongoose';

@Schema({
  collection: 'email_templates'
})
export class EmailTemplate {
  @Prop({
    index: true
  })
  name: string;

  @Prop({
    required: true,
    trim: true
  })
  key: string;

  @Prop()
  description: string;

  @Prop()
  subject: string;

  @Prop({
    default: ''
  })
  content: string;

  @Prop({
    default: ''
  })
  layout: string;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type EmailTemplateDocument = HydratedDocument<EmailTemplate>;

export const EmailTemplateSchema = SchemaFactory.createForClass(EmailTemplate);

EmailTemplateSchema.index({ key: 1 }, { unique: true });
