import {
  Prop, Schema, SchemaFactory, raw
} from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Types } from 'mongoose';

@Schema({
  collection: 'channels'
})
export class Channel {
  @Prop()
  name: string;

  @Prop({
    trim: true
  })
  slug: string;

  @Prop()
  description: string;

  @Prop({
    default: 'active',
    index: true
  })
  status: string;

  @Prop({
    type: Types.ObjectId
  })
  imageId: ObjectId;

  @Prop({
    default: false
  })
  allowSubscription: boolean;

  @Prop({
    default: 0
  })
  monthlySubscriptionPrice: number;

  @Prop({
    default: 0
  })
  yearlySubscriptionPrice: number;

  @Prop(raw({
    likes: { type: Number, default: 0 },
    subscribers: { type: Number, default: 0 },
    followers: { type: Number, default: 0 },
    views: { type: Number, default: 0 },
    videos: { type: Number, default: 0 }
  }))
  stats: {
    likes: number,
    subscribers: number,
    followers: number,
    views: number,
    videos: number
  };

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;

  @Prop()
  seoTitle: string;

  @Prop()
  seoKeywords: string;

  @Prop()
  seoDesc: string;
}

export type ChannelDocument = HydratedDocument<Channel>;

export const ChannelSchema = SchemaFactory.createForClass(Channel);
ChannelSchema.index({ slug: 1 }, { unique: true, sparse: true });
ChannelSchema.index({ name: 'text' });
ChannelSchema.index({ name: 1 });
