import {
  Prop, Schema, SchemaFactory, raw
} from '@nestjs/mongoose';
import { ObjectId } from 'mongodb';
import { HydratedDocument, Schema as MongooseSchema } from 'mongoose';

import { CATEGORY_GROUP } from 'src/constants';

@Schema({
  collection: 'categories'
})
export class Category {
  @Prop({
    trim: true,
    index: true
  })
  title: string;

  @Prop()
  description: string;

  @Prop({
    trim: true,
    index: true
  })
  slug: string; // alias name for SEO

  @Prop()
  seoTitle: string;

  @Prop()
  seoDesc: string;

  @Prop()
  seoKeywords: string;

  @Prop({
    type: MongooseSchema.Types.ObjectId
  })
  posterId: ObjectId;

  @Prop()
  status: string;

  @Prop({
    default: 0
  })
  ordering: Number;

  @Prop({
    default: CATEGORY_GROUP.VIDEO
  })
  group: string;

  @Prop(raw({
    videos: { type: Number, default: 0 }
  }))
  stats: {
    videos: number
  };

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type CategoryDocument = HydratedDocument<Category>;

export const CategorySchema = SchemaFactory.createForClass(Category);

CategorySchema.index({ group: 1, slug: 1 }, { unique: true, sparse: true });
CategorySchema.index({ title: 'text' });
