import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { HydratedDocument } from 'mongoose';

@Schema({
  collection: 'ads'
})
export class Ad {
  @Prop()
  name: string;

  @Prop()
  description: string;

  @Prop()
  adUrl: string;

  @Prop()
  type: string;

  @Prop()
  position: string;

  @Prop()
  fileId: string;

  @Prop()
  ordering: number;

  @Prop({
    default: 'active'
  })
  status: string;

  @Prop()
  scriptCode: string;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type AdDocument = HydratedDocument<Ad>;

export const AdSchema = SchemaFactory.createForClass(Ad);

AdSchema.index({ status: 1, type: 1 });
AdSchema.index({ status: 1, position: 1 });
AdSchema.index({ name: 1 });
AdSchema.index({ name: 'text' });
