import { IsOptional, IsString } from 'class-validator';

import { SearchRequest } from 'src/core';

export class VideoSearchPayload extends SearchRequest {
  @IsString()
  @IsOptional()
  createdBy: string;

  @IsString()
  @IsOptional()
  status: string;

  @IsString()
  @IsOptional()
  categoryIds: string;

  @IsString()
  @IsOptional()
  tags: string;

  @IsString()
  @IsOptional()
  performerIds: string;

  @IsOptional()
  verified: boolean;

  @IsOptional()
  isByMember: boolean;
}
