import {
  IsArray,
  IsBoolean,
  IsNotEmpty, IsNumber, IsOptional, IsString
} from 'class-validator';
import { ObjectId } from 'mongodb';

export class VideoCreatePayload {
  @IsString()
  @IsNotEmpty()
  title: string;

  @IsString()
  @IsOptional()
  description: string;

  @IsString()
  @IsOptional()
  slug: string;

  @IsString()
  @IsOptional()
  seoTitle: string;

  @IsString()
  @IsOptional()
  seoKeywords: string;

  @IsString()
  @IsOptional()
  seoDesc: string;

  @IsString()
  @IsOptional()
  status: string;

  @IsBoolean()
  @IsOptional()
  featured: boolean;

  @IsString()
  @IsOptional()
  fileId: string;

  @IsNumber()
  @IsOptional()
  price: number;

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  performerIds: ObjectId[];

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  tags: string[];

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  tagIds: ObjectId[];

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  categoryIds: ObjectId[];

  @IsOptional()
  createdBy: ObjectId;

  @IsBoolean()
  @IsOptional()
  verified: boolean;

  @IsBoolean()
  @IsOptional()
  isByMember: boolean;
}

