import { PartialType } from '@nestjs/mapped-types';
import {
  IsNotEmpty, IsOptional, IsString
} from 'class-validator';

export class TagCreatePayload {
  @IsString()
  @IsNotEmpty()
  key: string;

  @IsString()
  @IsNotEmpty()
  status: string;

  @IsString()
  @IsOptional()
  name: string;
}

export class TagUpdatePayload extends PartialType(TagCreatePayload) { }
