import {
  IsIn, IsNotEmpty, IsNumber, IsString
} from 'class-validator';

import { STAT_TYPES } from 'src/constants';

export class StatsUpdatePayload {
  @IsString()
  @IsIn(Object.values(STAT_TYPES))
  @IsNotEmpty()
  type: string;

  @IsString()
  @IsNotEmpty()
  field: string;

  @IsNumber()
  @IsNotEmpty()
  value: number;
}
