import {
  IsString, IsOptional, IsNotEmpty, IsIn, IsNumber
} from 'class-validator';
import { ObjectId } from 'mongodb';

import { REACTION_ACTION, REACTION_TYPE } from 'src/constants';

export class ReactionCreatePayload {
  @IsString()
  @IsOptional()
  @IsIn(Object.values(REACTION_TYPE))
  objectType = REACTION_TYPE.VIDEO;

  @IsString()
  @IsOptional()
  @IsIn(Object.values(REACTION_ACTION))
  action: string;

  @IsString()
  @IsNotEmpty()
  objectId: ObjectId;
}

export class ReactionUpdateStatsPayload {
  @IsString()
  @IsNotEmpty()
  @IsIn(Object.values(REACTION_ACTION))
  action: string;

  @IsNumber()
  @IsNotEmpty()
  value: number;
}
