import { IsOptional, IsString } from 'class-validator';
import { Types } from 'mongoose';

import { SearchRequest } from 'src/core';

export class ReactionSearchRequestPayload extends SearchRequest {
  @IsString()
  @IsOptional()
  objectId: string | Types.ObjectId;

  @IsString()
  @IsOptional()
  action: string;

  @IsString()
  @IsOptional()
  objectType: string;

  @IsString()
  @IsOptional()
  createdBy?: string | Types.ObjectId;
}
