import {
  IsString,
  IsOptional,
  IsEmail,
  Validate,
  IsIn,
  IsArray,
  IsISO31661Alpha2,
  IsBoolean
} from 'class-validator';

import { GENDER } from 'src/constants';

import { Username } from '../../validators/username.validator';

export class ProfileUpdatePayload {
  @IsString()
  @IsOptional()
  name: string;

  @IsString()
  @IsOptional()
  firstName: string;

  @IsString()
  @IsOptional()
  lastName: string;

  @IsString()
  @IsOptional()
  phone: string;

  @IsString()
  @IsIn(Object.values(GENDER))
  @IsOptional()
  gender: string;

  @IsString()
  @IsOptional()
  @IsISO31661Alpha2()
  country: string;

  @IsString()
  @IsOptional()
  city: string;

  @IsString()
  @IsOptional()
  state: string;

  @IsString()
  @IsOptional()
  address: string;

  @IsArray()
  @IsString({ each: true })
  @IsOptional()
  languages: string[];

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  categoryIds: string[];

  @IsString()
  @IsOptional()
  bio: string;

  @IsString()
  @IsOptional()
  dateOfBirth: Date;

  @IsString()
  @IsOptional()
  status: string;

  @IsString()
  @IsOptional()
  @Validate(Username)
  username: string;

  @IsEmail()
  @IsOptional()
  email: string;

  @IsString()
  @IsOptional()
  avatarId: string;
}

export class AdminProfileUpdatePayload extends ProfileUpdatePayload {
  @IsString()
  @IsOptional()
  @Validate(Username)
  username: string;

  @IsEmail()
  @IsOptional()
  email: string;

  @IsBoolean()
  @IsOptional()
  isModel: boolean;

  @IsBoolean()
  @IsOptional()
  verifiedEmail: boolean;

  @IsBoolean()
  @IsOptional()
  verifiedAccount: boolean;

  @IsBoolean()
  @IsOptional()
  verifiedDocument: boolean;
}
