import {
  IsString, IsOptional, IsIn, IsBoolean
} from 'class-validator';

import { GENDER } from 'src/constants';
import { SearchRequest } from 'src/core';

export class ProfileBasicSearchPayload extends SearchRequest {
  @IsString()
  @IsOptional()
  @IsIn(Object.values(GENDER))
  gender: string;

  @IsString()
  @IsOptional()
  country: string;

  @IsString()
  @IsOptional()
  hashTag: string;

  @IsString()
  @IsOptional()
  id: string;
}

export class ProfileAdvancedSearchPayload extends ProfileBasicSearchPayload {
  @IsString()
  @IsOptional()
  subscribed: boolean;

  @IsBoolean()
  @IsOptional()
  isModel: boolean;

  @IsBoolean()
  @IsOptional()
  verifiedEmail: boolean;

  @IsBoolean()
  @IsOptional()
  verifiedAccount: boolean;

  @IsBoolean()
  @IsOptional()
  verifiedDocument: boolean;

  @IsString()
  @IsOptional()
  status: string;
}
