import {
  IsString,
  IsOptional,
  IsEmail,
  Validate,
  IsIn,
  IsNotEmpty,
  IsISO31661Alpha2,
  IsDateString,
  IsBoolean,
  MinLength
} from 'class-validator';

import { GENDER, STATUS } from 'src/constants';

import { Username } from '../../validators/username.validator';

export class ProfileCreatePayload {
  @IsString()
  @IsOptional()
  firstName?: string;

  @IsString()
  @IsOptional()
  lastName?: string;

  @IsString()
  @IsOptional()
  name?: string;

  @IsString()
  @IsOptional()
  phone?: string;

  @IsString()
  @IsNotEmpty()
  @IsEmail()
  email: string;

  @IsString()
  @Validate(Username)
  @IsNotEmpty()
  username: string;

  @IsString()
  @IsIn(Object.values(GENDER))
  @IsOptional()
  gender: string;

  @IsString()
  @IsOptional()
  @IsISO31661Alpha2()
  country: string;

  @IsString()
  @IsOptional()
  status: string = STATUS.ACTIVE;

  @IsString()
  @IsOptional()
  @IsDateString()
  dateOfBirth: Date;

  @IsBoolean()
  @IsOptional()
  verifiedEmail: boolean = false;

  @IsBoolean()
  @IsOptional()
  verifiedAccount: boolean = false;

  @IsBoolean()
  @IsOptional()
  verifiedDocument: boolean = false;

  @IsString()
  @IsOptional()
  @MinLength(8)
  password: string;

  @IsString()
  @IsOptional()
  avatarId: string;
}
