import {
  IsArray,
  IsNotEmpty, IsOptional, IsString
} from 'class-validator';
import { ObjectId } from 'mongodb';

export class PostCreatePayload {
  @IsString()
  @IsNotEmpty()
  title: string;

  @IsString()
  @IsNotEmpty()
  content: string;

  @IsString()
  @IsOptional()
  slug: string;

  @IsString()
  @IsOptional()
  seoTitle: string;

  @IsString()
  @IsOptional()
  seoKeywords: string;

  @IsString()
  @IsOptional()
  seoDesc: string;

  @IsString()
  @IsOptional()
  status: string;

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  categoryIds: ObjectId[];
}
