import { IsNotEmpty, IsOptional, IsString } from 'class-validator';

export class PerformerCreatePayload {
  @IsString()
  @IsNotEmpty()
  name: string;

  @IsString()
  @IsOptional()
  username: string;

  @IsString()
  @IsNotEmpty()
  gender: string;

  @IsString()
  @IsNotEmpty()
  status: string;

  @IsString()
  @IsOptional()
  avatarId: string;

  @IsString()
  @IsOptional()
  coverId: string;

  @IsString()
  @IsOptional()
  bio: string;

  @IsString()
  @IsOptional()
  seoTitle: string;

  @IsString()
  @IsOptional()
  seoKeywords: string;

  @IsString()
  @IsOptional()
  seoDesc: string;
}
