import {
  IsString,
  IsOptional,
  IsNotEmpty,
  IsObject
} from 'class-validator';

export class SendMailPayload {
  @IsString()
  @IsOptional()
  template?: string;

  @IsNotEmpty()
  to: string | string[];

  @IsOptional()
  cc?: string | string[];

  @IsOptional()
  bcc?: string | string[];

  @IsString()
  @IsOptional()
  html?: string; // overwrite content to send if template is not provided

  @IsString()
  @IsOptional()
  layout?: string = 'default';

  @IsString()
  @IsOptional()
  subject?: string;

  @IsObject()
  @IsOptional()
  data?: Record<string, any>;
}
