import { PartialType } from '@nestjs/mapped-types';
import {
  IsBoolean, IsNotEmpty, IsNumber, IsOptional, IsString
} from 'class-validator';

export class ChannelCreatePayload {
  @IsString()
  @IsNotEmpty()
  name: string;

  @IsString()
  @IsOptional()
  slug: string;

  @IsString()
  @IsOptional()
  description: string;

  @IsString()
  @IsNotEmpty()
  status: string;

  @IsString()
  @IsOptional()
  imageId: string;

  @IsBoolean()
  @IsOptional()
  allowSubscription: boolean;

  @IsNumber()
  @IsOptional()
  monthlySubscriptionPrice: number;

  @IsNumber()
  @IsOptional()
  yearlySubscriptionPrice: number;

  @IsString()
  @IsOptional()
  seoTitle: string;

  @IsString()
  @IsOptional()
  seoKeywords: string;

  @IsString()
  @IsOptional()
  seoDesc: string;
}

export class ChannelUpdatePayload extends PartialType(ChannelCreatePayload) { }
