import {
  IsNotEmpty, IsNumber, IsOptional, IsString
} from 'class-validator';

import { CATEGORY_GROUP } from 'src/constants';

export class CategoryCreatePayload {
  @IsString()
  @IsNotEmpty()
  title: string;

  @IsString()
  @IsOptional()
  description: string;

  @IsString()
  @IsOptional()
  slug: string;

  @IsString()
  @IsOptional()
  seoTitle: string;

  @IsString()
  @IsOptional()
  seoKeywords: string;

  @IsString()
  @IsOptional()
  seoDesc: string;

  @IsString()
  @IsOptional()
  status: string;

  @IsNumber()
  @IsOptional()
  ordering: number;

  @IsString()
  @IsOptional()
  group: string = CATEGORY_GROUP.VIDEO;

  @IsString()
  @IsOptional()
  posterId: string;
}
