import { IsString, IsNotEmpty, MinLength } from 'class-validator';
import { ObjectId } from 'mongodb';

export class AdminChangePasswordPayload {
  @IsString()
  @IsNotEmpty()
  profileId: ObjectId;

  @IsString()
  @IsNotEmpty()
  @MinLength(8)
  password: string;
}
