import { PartialType } from '@nestjs/mapped-types';
import {
  IsIn,
  IsNotEmpty, IsNumber, IsOptional, IsString, ValidateIf
} from 'class-validator';

import { AD_POSITION, AD_TYPE } from 'src/constants';

export class AdCreatePayload {
  @IsString()
  @IsNotEmpty()
  name: string;

  @IsString()
  @IsOptional()
  // @ValidateIf((o) => o.type !== AD_TYPE.SCRIPT_CODE)
  // @IsNotEmpty()
  adUrl: string;

  @IsString()
  @IsIn(Object.values(AD_TYPE))
  @IsNotEmpty()
  type: string;

  @IsString()
  @IsOptional()
  @ValidateIf((o) => o.type === AD_TYPE.SCRIPT_CODE)
  @IsNotEmpty()
  scriptCode: string;

  @IsString()
  @IsOptional()
  @IsIn(Object.values(AD_POSITION))
  position: string;

  @IsString()
  @IsOptional()
  description: string;

  @IsString()
  @IsOptional()
  @ValidateIf((o) => o.type === AD_TYPE.IMAGE || o.type === AD_TYPE.VIDEO)
  @IsNotEmpty()
  fileId: string;

  @IsString()
  @IsOptional()
  status: string;

  @IsNumber()
  @IsOptional()
  ordering: number;
}

export class AdUpdatePayload extends PartialType(AdCreatePayload) { }
