import { ValidationPipe } from '@nestjs/common';
import { ConfigService } from '@nestjs/config';
import { NestFactory } from '@nestjs/core';

import { AppModule } from './app.module';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);

  /**
   * allow CORS
   * TODO - check and allow for valid domains only
   */
  app.enableCors();

  /**
   * global setings for validator
   */
  app.useGlobalPipes(
    new ValidationPipe({
      transform: true,
      whitelist: true
    })
  );

  const config = app.get<ConfigService>(ConfigService);
  const port = config.get('PORT');

  await app.listen(port);
  // eslint-disable-next-line no-console
  console.info(`Application is running at port ${port}`);
}
bootstrap();
