import { Injectable } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Job } from 'bullmq';
import { Model } from 'mongoose';

import { EVENT } from 'src/constants';
import { QueueMessageService } from 'src/core';
import { Video, VideoDocument } from 'src/schemas';

@Injectable()
export class VideoTagListener {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    @InjectModel(Video.name)
    private readonly videoModel: Model<VideoDocument>
  ) {
    this.queueMessageService.subscribe('VIDEO_TAG_CHANNEL', 'VIDEO_TAG_CHANNEL_PROCESS', this.handleDeleteTag.bind(this));
  }

  async handleDeleteTag(job: Job) {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const { _id, eventName } = job.data.data;
    if (eventName === EVENT.DELETED) this.videoModel.updateMany({ tags: _id }, { $pull: { tags: _id } });
  }
}
