import { Injectable, OnModuleInit } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';

import {
  TOPIC_UPDATE_VIDEO_CONVERT_STATUS,
  VIDEO_FILE_CHANNEL
} from 'src/constants';
import { QueueEvent, QueueMessageService } from 'src/core';
import {
  Video, VideoDocument
} from 'src/schemas';

@Injectable()
export class UpdateVideoConvertStatusListener implements OnModuleInit {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    @InjectModel(Video.name) private readonly VideoModel: Model<VideoDocument>
  ) { }

  onModuleInit() {
    this.listenQueueMessage();
  }

  async listenQueueMessage() {
    await this.queueMessageService.subscribe(VIDEO_FILE_CHANNEL, TOPIC_UPDATE_VIDEO_CONVERT_STATUS, this.handleMediaConverted.bind(this));
  }

  private async handleMediaConverted({ data }: QueueEvent<any>) {
    /**
     * sample file data
     * {
        eventName: 'file_uploaded',
        data: {
          postbackData: { mediaId: '64db353c807e14f51ca6b0b6' },
          file: {
            _id: '64edc0bfd9b3322dd6d83232',
            status: 'active',
            height: 1024,
            url: 'https://abc.com/image/upload/v1693303097/64edc0bfd9b3322dd6d83232.jpg',
          },
          status: 'processed' | 'error' | 'uploaded'
        }
      }
     */

    const { status, file } = data.data;

    // TODO - handle error case?
    if (['success', 'processed', 'error'].includes(status)) {
      // TODO - optimize me
      await this.VideoModel.updateOne({ fileId: file._id }, {
        convertStatus: status,
        isHD: file.width > 1080,
        status: status === 'error' ? 'inactive' : 'active',
        duration: Math.floor(file.meta.duration)
      });
    }
    // TODO - handle call delete file if error
    return true;
  }
}
