import { Injectable, OnModuleInit } from '@nestjs/common';

import {
  EVENT, REACTION_CHANNEL
} from 'src/constants';
import { QueueEvent, QueueMessageService } from 'src/core';
import { ReactionDto } from 'src/dtos';
import { ReactionObjectService } from 'src/services';

const TOPIC_REACTION_HANDLE_UPDATE_OBJECT = 'TOPIC_REACTION_HANDLE_UPDATE_OBJECT';

@Injectable()
export class ReactionListener implements OnModuleInit {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    private readonly reactionObjectService: ReactionObjectService
  ) { }

  onModuleInit() {
    this.listenQueueMessage();
  }

  async listenQueueMessage() {
    await this.queueMessageService.subscribe(REACTION_CHANNEL, TOPIC_REACTION_HANDLE_UPDATE_OBJECT, this.handleUpdateObjectStats.bind(this));
  }

  public async handleUpdateObjectStats({ data }: QueueEvent<any>) {
    const { eventName } = data;
    const reaction: ReactionDto = data.data;
    const value = eventName === EVENT.CREATED ? 1 : -1;
    await this.reactionObjectService.updateStats(reaction.objectType, reaction.objectId, { action: reaction.action, value });
  }
}
