import { Injectable } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Job } from 'bullmq';
import { Model } from 'mongoose';

import { EVENT } from 'src/constants';
import { QueueMessageService } from 'src/core';
import { Reaction, ReactionDocument } from 'src/schemas';

@Injectable()
export class ReactionVideoListener {
  constructor(
    @InjectModel(Reaction.name)
    private readonly reactionModel: Model<ReactionDocument>,
    private readonly queueMessageService: QueueMessageService
  ) {
    this.queueMessageService.subscribe('REACTION_VIDEO', 'REACTION_VIDEO_PROCESS', this.handleReactionVideo.bind(this));
  }

  async handleReactionVideo(job: Job) {
    const { data, eventName } = job.data;
    if (eventName === EVENT.DELETED) {
      this.reactionModel.deleteMany({ action: 'like', objectType: 'video', objectId: data._id });
    }
  }
}
