import { Injectable, OnModuleInit } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';

import {
  STAT_TYPES, PROFILE_CHANNEL, STATS_MEMBER_FIELDS, EVENT
} from 'src/constants';
import { QueueEvent, QueueMessageService } from 'src/core';
import { ProfileDto } from 'src/dtos';
import { Profile, ProfileDocument } from 'src/schemas';
import { StatsService } from 'src/services';

const TOPIC_PROFILE_HANDLE_UPDATE_STATS = 'TOPIC_PROFILE_HANDLE_UPDATE_STATS';

@Injectable()
export class ProfileListener implements OnModuleInit {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    @InjectModel(Profile.name) private readonly ProfileModel: Model<ProfileDocument>,
    private readonly statService: StatsService
  ) { }

  onModuleInit() {
    this.listenQueueMessage();
  }

  async listenQueueMessage() {
    await this.queueMessageService.subscribe(PROFILE_CHANNEL, TOPIC_PROFILE_HANDLE_UPDATE_STATS, this.handleUpdateStats.bind(this));
  }

  private async updateSystemStats(profile: ProfileDto) {
    if (profile) {
      const count = await this.ProfileModel.countDocuments({});

      await this.statService.updateStats({
        type: STAT_TYPES.MEMBER,
        field: STATS_MEMBER_FIELDS.TOTAL,
        value: count
      });
    }
  }

  public async handleUpdateStats({ data }: QueueEvent<any>) {
    const { eventName } = data;
    if (![EVENT.CREATED, EVENT.DELETED].includes(eventName)) {
      return;
    }
    const profile: ProfileDto = data.data;
    await this.updateSystemStats(profile);
  }
}
