import { Injectable, OnModuleInit } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';

import {
  EVENT,
  PERFORMER_CHANNEL
} from 'src/constants';
import { QueueEvent, QueueMessageService } from 'src/core';
import { PerformerDto } from 'src/dtos';
import { Reaction, ReactionDocument } from 'src/schemas';

const TOPIC_REMOVE_PERFORMER_REACTION = 'TOPIC_REMOVE_PERFORMER_REACTION';

@Injectable()
export class PerformerListener implements OnModuleInit {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    @InjectModel(Reaction.name) private readonly ReactionModel: Model<ReactionDocument>
  ) { }

  onModuleInit() {
    this.listenQueueMessage();
  }

  async listenQueueMessage() {
    await this.queueMessageService.subscribe(PERFORMER_CHANNEL, TOPIC_REMOVE_PERFORMER_REACTION, this.handleRemovePerformerReaction.bind(this));
  }

  public async handleRemovePerformerReaction({ data }: QueueEvent<any>) {
    const { eventName } = data;
    if (![EVENT.CREATED, EVENT.DELETED].includes(eventName)) {
      return;
    }
    const performer: PerformerDto = data.data;
    if (eventName === EVENT.DELETED) {
      await this.ReactionModel.deleteMany({ objectId: performer._id });
    }
  }
}
