import { Injectable, OnModuleInit } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';

import {
  VIDEO_CHANNEL_CHANNEL,
  EVENT
} from 'src/constants';
import { QueueEvent, QueueMessageService } from 'src/core';
import { ChannelDto } from 'src/dtos';
import { Reaction, ReactionDocument } from 'src/schemas';

const TOPIC_REMOVE_CHANNEL_REACTION = 'TOPIC_REMOVE_CHANNEL_REACTION';

@Injectable()
export class ChannelListener implements OnModuleInit {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    @InjectModel(Reaction.name) private readonly ReactionModel: Model<ReactionDocument>
  ) { }

  onModuleInit() {
    this.listenQueueMessage();
  }

  async listenQueueMessage() {
    await this.queueMessageService.subscribe(VIDEO_CHANNEL_CHANNEL, TOPIC_REMOVE_CHANNEL_REACTION, this.handleRemoveChannelReaction.bind(this));
  }

  public async handleRemoveChannelReaction({ data }: QueueEvent<any>) {
    const { eventName } = data;
    if (![EVENT.CREATED, EVENT.DELETED].includes(eventName)) {
      return;
    }
    const channel: ChannelDto = data.data;
    if (eventName === EVENT.DELETED) {
      await this.ReactionModel.deleteMany({ objectId: channel._id });
    }
  }
}
