import { Injectable, OnModuleInit } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';

import {
  STAT_TYPES, CATEGORY_CHANNEL, CATEGORY_GROUP, STATS_CATEGORY_FIELDS, EVENT
} from 'src/constants';
import { QueueEvent, QueueMessageService } from 'src/core';
import { CategoryDto } from 'src/dtos';
import { Category, CategoryDocument } from 'src/schemas';
import { StatsService } from 'src/services';

const TOPIC_CATEGORY_HANDLE_UPDATE_STATS = 'TOPIC_CATEGORY_HANDLE_UPDATE_STATS';

@Injectable()
export class CategoryListener implements OnModuleInit {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    @InjectModel(Category.name) private readonly CategoryModel: Model<CategoryDocument>,
    private readonly statService: StatsService
  ) { }

  onModuleInit() {
    this.listenQueueMessage();
  }

  async listenQueueMessage() {
    await this.queueMessageService.subscribe(CATEGORY_CHANNEL, TOPIC_CATEGORY_HANDLE_UPDATE_STATS, this.handleUpdateStats.bind(this));
  }

  private async updateSystemStats(category: CategoryDto) {
    if (category.group === CATEGORY_GROUP.VIDEO) {
      const count = await this.CategoryModel.countDocuments({
        group: CATEGORY_GROUP.VIDEO
      });

      await this.statService.updateStats({
        type: STAT_TYPES.CATEGORY,
        field: STATS_CATEGORY_FIELDS.VIDEO_CATEGORY,
        value: count
      });
    }
  }

  public async handleUpdateStats({ data }: QueueEvent<any>) {
    const { eventName } = data;
    if (![EVENT.CREATED, EVENT.DELETED].includes(eventName)) {
      return;
    }
    const category: CategoryDto = data.data;
    await this.updateSystemStats(category);
  }
}
