import { Injectable, OnModuleInit } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';

import {
  STAT_TYPES, VIDEO_AD_CHANNEL, STATS_AD_FIELDS, STANDARD_AD_CHANNEL, EVENT
} from 'src/constants';
import { QueueEvent, QueueMessageService } from 'src/core';
import {
  Ad, AdDocument
} from 'src/schemas';
import { VideoAds, VideoAdsDocument } from 'src/schemas/video-ads.schema';
import { StatsService } from 'src/services';

const TOPIC_VIDEO_ADS_HANDLE_UPDATE_STATS = 'TOPIC_VIDEO_ADS_HANDLE_UPDATE_STATS';
const TOPIC_STANDARD_ADS_HANDLE_UPDATE_STATS = 'TOPIC_STANDARD_ADS_HANDLE_UPDATE_STATS';

@Injectable()
export class AdsListener implements OnModuleInit {
  constructor(
    private readonly queueMessageService: QueueMessageService,
    @InjectModel(VideoAds.name) private readonly VideoAdsModel: Model<VideoAdsDocument>,
    @InjectModel(Ad.name) private readonly AdsModel: Model<AdDocument>,
    private readonly statService: StatsService
  ) { }

  onModuleInit() {
    this.listenQueueMessage();
  }

  async listenQueueMessage() {
    await this.queueMessageService.subscribe(VIDEO_AD_CHANNEL, TOPIC_VIDEO_ADS_HANDLE_UPDATE_STATS, this.handleUpdateVideoAdsStats.bind(this));
    await this.queueMessageService.subscribe(STANDARD_AD_CHANNEL, TOPIC_STANDARD_ADS_HANDLE_UPDATE_STATS, this.handleUpdateStandardAdsStats.bind(this));
  }

  public async handleUpdateVideoAdsStats({ data }: QueueEvent<any>) {
    const { eventName } = data;
    if (![EVENT.CREATED, EVENT.DELETED].includes(eventName)) {
      return;
    }
    const count = await this.VideoAdsModel.countDocuments({});
    await this.statService.updateStats({
      type: STAT_TYPES.AD,
      field: STATS_AD_FIELDS.VIDEO,
      value: count
    });
  }

  public async handleUpdateStandardAdsStats({ data }: QueueEvent<any>) {
    const { eventName } = data;
    if (![EVENT.CREATED, EVENT.DELETED].includes(eventName)) {
      return;
    }
    const count = await this.AdsModel.countDocuments({});
    await this.statService.updateStats({
      type: STAT_TYPES.AD,
      field: STATS_AD_FIELDS.STANDARD,
      value: count
    });
  }
}
