export interface IExtractResponse {
  /**
   * id from ref service
   */
  id: string;
  /**
   * video name
   */
  title: string;

  /**
   * video description
   */
  description: string;
  /**
   * iframe url
   */
  embeddedCode?: string;
  /**
   * duration of the video
   */
  duration?: number;

  /**
   * url of the main thumbnail if any
   */
  thumbnails?: string[];

  /**
   * video preview or image
   */
  teaser?: string;
  // TODO - add any

  /**
   * video categories
   */
  categories?: string;

  /**
   * video tags
   */
  tags?: string;

  /**
   * video models
   */
  models?: string;

  /**
   * video url
   */
  url?: string;
}

export interface IPartnerVideo {
  name: string;
  website: string;
  url: string;
  categoryEndpoint: string;
  searchEndpoint: string;
  embed: string;
  partner: string;
}

export interface IPartnerCategoryResponse {
  label: string,
  value: string;
}

export interface IAWEmpireVideoConfig {
  name: string;
  website: string;
  url: string;
  categoryEndpoint: string;
  searchEndpoint: string;
  embedUrl: string;
  partner: string;
  pstoolEmbed: string;
  pstoolSearch: string;
}
