import {
  Injectable,
  NestInterceptor,
  ExecutionContext,
  CallHandler
} from '@nestjs/common';
import { Observable } from 'rxjs';

import { AuthService } from 'src/services';

@Injectable()
export class UserInterceptor implements NestInterceptor {
  constructor(private readonly authService: AuthService) { }

  async intercept(
    context: ExecutionContext,
    next: CallHandler
  ): Promise<Observable<any>> {
    const ctx = context.switchToHttp();
    const request = ctx.getRequest();

    if (request.headers.authorization) {
      const profile = await this.authService.getProfileFromJwt(request.headers.authorization);
      if (profile) {
        request.user = profile;
      }
    }
    request.jwToken = request.headers.authorization;
    return next.handle();
  }
}
