import { Injectable, CanActivate, ExecutionContext } from '@nestjs/common';

import { AuthService } from 'src/services';

@Injectable()
export class LoadProfile implements CanActivate {
  constructor(private readonly authService: AuthService) { }

  async canActivate(context: ExecutionContext): Promise<boolean> {
    try {
      const request = context.switchToHttp().getRequest();
      const token = request.headers.authorization || request?.query?.authorization || request?.query?.Authorization;
      if (!token || token === 'null') return true;
      const res = await this.authService.getProfileFromJwt(token);
      if (!res || res.status !== 'active') {
        return true;
      }

      if (!request.user) request.user = res;

      return true;
    } catch {
      return true;
    }
  }
}
