import {
  Injectable, CanActivate, ExecutionContext
} from '@nestjs/common';

import { INVALID_USERNAME } from 'src/constants';

@Injectable()
export class PreventInvalidUsernameGuard implements CanActivate {
  async canActivate(context: ExecutionContext): Promise<boolean> {
    const request = context.switchToHttp().getRequest();

    // prevent if body request or params have usename field but it is invalid username
    if (request.params.username) {
      const found = INVALID_USERNAME.find((n) => n.toString().toLowerCase() === String(request.params.username).toLowerCase());
      if (found) return false;
    }
    if (request.body.username) {
      const found = INVALID_USERNAME.find((n) => n.toString().toLowerCase() === String(request.body.username).toLowerCase());
      if (found) return false;
    }

    return true;
  }
}
