import * as sharp from 'sharp';

export class FileImageService {
  /**
   * resize iamge file
   * @param filePath
   * @param options
   * @returns
   */
  public async resize(filePath: string | Buffer, options?: {
    width?: number;
    height?: number;
    toPath?: string;
    quality?: number;
    format?: keyof sharp.FormatEnum | sharp.AvailableFormatInfo;
  }) {
    // eslint-disable-next-line no-param-reassign
    options = options || {
      width: 200, // TODO - from config
      height: undefined,
      quality: 70,
      format: sharp.format.png
    };

    if (options.toPath) {
      return sharp(filePath)
        .resize(options.width, options.height)
        .rotate()
        .toFormat(options.format || sharp.format.png, { progressive: true, force: true, quality: options.quality || 70 })
        .toFile(options.toPath);
    }

    return sharp(filePath)
      .resize(options.width, options.height)
      .rotate()
      .toFormat(options.format || sharp.format.png, { progressive: true, force: true, quality: options.quality || 70 })
      .toBuffer();
  }

  public async getMetaData(filePath: string | Buffer) {
    return sharp(filePath).metadata();
  }

  public async replaceWithoutExif(filePath: string) {
    return sharp(filePath)
      .rotate()
      .toBuffer();
  }

  public async blur(input: string | Buffer, options = {
    sigma: 6, // a value between 0.3 and 1000 representing the sigma of the Gaussian mask, where sigma = 1 + radius / 2
    width: 100,
    quality: 70
  }) {
    let { sigma = 10 } = options;
    const { width = 100 } = options;
    if (sigma < 0.3 || sigma > 1000) sigma = 10;

    return sharp(input)
      .resize(width)
      .jpeg({ progressive: true, force: true, quality: options.quality || 70 })
      .blur(sigma)
      .toBuffer();
  }

  public isSupportedFormat(format: string) {
    return [
      'heic', 'heif', 'avif', 'jpeg', 'jpg', 'jpe', 'tile', 'dz', 'png', 'raw', 'tiff', 'tif', 'webp', 'gif', 'jp2', 'jpx', 'j2k', 'j2c', 'jxl'
    ].includes(format);
  }
}
