import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { HydratedDocument, Types } from 'mongoose';

import { IVideoStorage } from '../interfaces';

@Schema({
  collection: 'files'
})
export class File {
  @Prop()
  assetId: string; // ref asset ID

  @Prop({
    index: true
  })
  jobId: string; // ref job ID, such as AWS MediaConvert job ID

  @Prop()
  name: string;

  @Prop()
  source: string;

  @Prop()
  type: string; // internal type of file

  @Prop()
  mediaType: string; // video or photo

  @Prop()
  uploadedBy: string;

  @Prop()
  status: string;

  @Prop({
    type: Types.Map
  })
  meta: any;

  @Prop({
    type: Types.Map
  })
  notification: any;

  @Prop()
  size: number;

  @Prop()
  width: number;

  @Prop()
  height: number;

  @Prop()
  bytes: number;

  @Prop()
  format: string;

  @Prop()
  mime: string;

  @Prop()
  version: string;

  @Prop({
    index: true
  })
  path: string;

  @Prop()
  blurImagePath: string;

  @Prop()
  thumbnailPath: string;

  @Prop()
  url: string;

  @Prop()
  acl: string;

  @Prop({
    // TODO - define schema separately
    // type: [{
    //   key: String,
    //   bucket: String,
    //   url: String,
    //   acl: String,
    //   type: String,
    //   preset: String,
    //   width: Number,
    //   height: Number,
    //   format: String
    // }]
    type: Types.Map
  })
  videos: IVideoStorage[];

  @Prop({
    type: Types.Map
  })
  poster: IVideoStorage;

  @Prop()
  error: string;

  // custom metadata to process file
  @Prop({
    type: Types.Map
  })
  params: any;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type FileDocument = HydratedDocument<File>;

export const FileSchema = SchemaFactory.createForClass(File);
