import { OmitType } from '@nestjs/mapped-types';
import { Type } from 'class-transformer';
import {
  IsString,
  IsNotEmpty,
  IsOptional,
  IsObject,
  IsIn,
  IsNumber,
  ValidateNested,
  IsBoolean
} from 'class-validator';

export class IFileUploadedNotification {
  @IsString()
  @IsOptional()
  channel?: string;

  @IsObject()
  @IsNotEmpty()
  data: any;

  @IsString()
  @IsOptional()
  webhookUrl?: string;
}

export class IFileUploadCustomParams {
  @IsBoolean()
  @IsOptional()
  createThumbnail: boolean = true;

  @IsNumber()
  @IsOptional()
  forceImageWidth?: number;

  @IsNumber()
  @IsOptional()
  forceImageHeight?: number;

  @IsBoolean()
  @IsOptional()
  createBlurImage: boolean = true;
}

export class SignedUploadRequestPayload {
  @IsString()
  @IsNotEmpty()
  @IsIn(['video', 'image'])
  mediaType: string;

  @IsString()
  @IsNotEmpty()
  type: string; // type of that asset such as avatar

  @IsString()
  @IsOptional()
  uploaderId?: string;

  @IsString()
  @IsOptional()
  @IsIn(['public-read', 'authenticated-read'])
  acl?: string = 'authenticated-read';

  @IsString()
  @IsOptional()
  filename?: string;

  @IsObject()
  @IsOptional()
  @ValidateNested()
  @Type(() => IFileUploadedNotification)
  notification?: IFileUploadedNotification;

  @IsObject()
  @IsOptional()
  @ValidateNested()
  @Type(() => IFileUploadCustomParams)
  params?: IFileUploadCustomParams;
}

export class DocumentUploadRequestPayload extends OmitType(SignedUploadRequestPayload, ['mediaType']) {
  @IsString()
  @IsNotEmpty()
  type: string; // type of that asset such as document
}
