import { Type } from 'class-transformer';
import {
  IsNotEmpty,
  IsArray,
  ValidateNested,
  IsString,
  IsOptional,
  IsNumber
} from 'class-validator';

export class SignUrlsPayload {
  @IsArray()
  @IsNotEmpty()
  @ValidateNested({ each: true })
  @Type(() => String)
  fileIds: string[];

  @IsString()
  @IsOptional()
  bucket?: string;

  @IsNumber()
  @IsOptional()
  expiresIn?: number;
}
