import {
  IsString,
  IsNotEmpty,
  IsOptional,
  IsNumber
} from 'class-validator';

export class SignUrlPayload {
  @IsString()
  @IsNotEmpty()
  fileId: string;

  @IsString()
  @IsOptional()
  bucket?: string;

  @IsNumber()
  @IsOptional()
  expiresIn?: number;
}
