import {
  IsOptional,
  IsNumber,
  IsBoolean,
  IsString,
  IsNotEmpty,
  IsArray,
  IsIP
} from 'class-validator';

export class GetFilesPublicPayload {
  @IsArray()
  @IsString({ each: true })
  @IsNotEmpty()
  fileIds: string[];

  @IsBoolean()
  @IsOptional()
  authenticated?: boolean;

  @IsNumber()
  @IsOptional()
  expiresIn?: number;

  @IsString()
  @IsIP()
  ip?: string; // custom IP for view
}
