import {
  IsOptional,
  IsNumber,
  IsBoolean,
  IsString,
  IsIP
} from 'class-validator';
import { ObjectId } from 'mongodb';

export class GetFilePublicPayload {
  @IsOptional()
  @IsString()
  fileId?: string | ObjectId;

  @IsBoolean()
  @IsOptional()
  authenticated?: boolean;

  @IsNumber()
  @IsOptional()
  expiresIn?: number;

  @IsString()
  @IsIP()
  ip?: string; // custom IP for view
}
