import { Type } from 'class-transformer';
import {
  IsString,
  IsNotEmpty,
  IsOptional,
  IsObject,
  IsIn,
  ValidateNested
} from 'class-validator';

import { IFileUploadedNotification } from './signed-upload-request.payload';

export class DownloadPosterPayload {
  @IsString()
  @IsNotEmpty()
  url?: string;

  @IsString()
  @IsOptional()
  @IsIn(['public-read', 'authenticated-read'])
  acl?: string = 'authenticated-read';

  @IsString()
  @IsOptional()
  filename?: string;

  @IsObject()
  @IsOptional()
  @ValidateNested()
  @Type(() => IFileUploadedNotification)
  notification?: IFileUploadedNotification;
}
