import * as jwt from 'jsonwebtoken';
import { ObjectId } from 'mongodb';

import { isUrl } from 'src/core';

/**
 * JWT use for hash / check auth for file, we can random this value
 */
export const JWT_FILE_SECRET = process.env.JWT_SECRET || 'ClwCF8oSDST5PLMVtjKOed5wNouDJ8JP';

export interface IGetSignedUrlOptions {
  source?: string;
  authenticated?: boolean;
  expiresIn?: number;
  fileId?: string | ObjectId;
  ip?: string;
  excludeHash?: boolean;
}

export const encryptJwt = (options: IGetSignedUrlOptions) => {
  const {
    fileId = null,
    expiresIn = 60 * 60,
    ip = ''
  } = options || {};

  return jwt.sign(
    {
      fileId,
      ip
    },
    JWT_FILE_SECRET,
    { expiresIn }
  );
};

export const generateSignedUrlFromPath = async (filePath: string, options?: IGetSignedUrlOptions) => {
  const {
    source = 'local',
    excludeHash
  } = options || {};
  if (source === 'local') {
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    // TODO - check base URL if available
    const newUrl = isUrl(filePath) ? new URL(filePath) : new URL(filePath, process.env.FILE_BASE_URL || process.env.BASE_URL);

    if (!excludeHash) {
      const hash = encryptJwt(options);
      newUrl.searchParams.delete('hash');
      newUrl.searchParams.append('hash', hash);
    }

    return {
      url: newUrl.href
    };
  }

  return {
    url: (isUrl(filePath) ? new URL(filePath) : new URL(filePath, process.env.FILE_BASE_URL || process.env.BASE_URL)).href
  };
};

/**
 * verify jwt from hash
 * @param dataToCompare Object fileId and ip to compare
 * @param hash
 */
export const verifyHash = (hash: string, dataToCompare?: Record<string, any>) => {
  try {
    const decodded = jwt.verify(hash, JWT_FILE_SECRET);
    const compareObj = dataToCompare || {};
    const notMatch = Object.keys(compareObj).find((key) => compareObj[key] && !decodded[key]);
    return !notMatch;
  } catch {
    return false;
  }
};
