import { HttpModule } from '@nestjs/axios';
import { Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { MongooseModule } from '@nestjs/mongoose';

import configuration from 'src/config/configuration';
import fileConfig from 'src/config/file.config';
import { CoreQueueModule } from 'src/core';

import { FileController } from './controllers';
import {
  File,
  FileSchema
} from './schemas';
import {
  FileService,
  FileVideoService,
  FileImageService,
  LocalFileUploadService
} from './services';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
      load: [
        configuration,
        fileConfig
      ]
    }),
    CoreQueueModule.register({
      // TODO - refator me
    }),
    HttpModule.register({
      timeout: 10000,
      maxRedirects: 5
    }),
    MongooseModule.forRootAsync({
      imports: [ConfigModule],
      useFactory: async (configService: ConfigService) => ({
        uri: configService.get<string>('MONGODB_URI')
      }),
      inject: [ConfigService]
    }),
    MongooseModule.forFeature([
      {
        name: File.name,
        schema: FileSchema
      }
    ])
  ],
  controllers: [
    FileController
  ],
  providers: [
    FileService,
    FileVideoService,
    FileImageService,
    LocalFileUploadService
  ],
  exports: [
    FileService,
    FileVideoService,
    FileImageService
  ]
})
export class FileModule { }
